{ CRYPTOR: Decrypt/Encrypt Cryptor Unit }

UNIT CRYPTOR;

INTERFACE

{$I CRYPTOR.INC}

TYPE
   AnyStr = STRING[255];   { Varying length string }

PROCEDURE Init_Hash;
PROCEDURE Decode(VAR Message : AnyStr);

IMPLEMENTATION

CONST
   First_Char  = 0;             { First ascii character }
   Last_Char   = 254;           { Last ascii character  }
   Blank_Char  = 32;            { Ascii blank           }
   Span        = (Last_Char-Blank_Char);  { # of characters  }

CONST
   M  = 714025;
   IA = 1366;
   IC = 150889;
   RM = 1.400512E-6;

VAR
   StringKey : AnyStr;                   { Encryption string   }
   RanSeed   : LONGINT;                  { Random number seed  }
   Y         : LONGINT;
   R         : ARRAY[1..97] OF LONGINT;

{----------------------------------------------------------------------}
{      SetRandom --- Set the seed for the random number generator      }
{----------------------------------------------------------------------}
PROCEDURE SetRandom(VAR Seed : LONGINT);

VAR
   J : INTEGER;

begin
  if (Seed > 0) then Seed := -Seed;
  Seed := (IC - Seed) MOD M;

  for J := 1 to 97 do
     begin
        Seed := (IA * Seed + IC) MOD M;
        R[J] := Seed;
     end;

  Seed := (IA * Seed + IC) MOD M;
  Y    := Seed;
end;

{----------------------------------------------------------------------}
{         Random --- Get a uniform random number between 0 and 1       }
{----------------------------------------------------------------------}
FUNCTION Random(VAR Seed : LONGINT) : REAL;

VAR
   J : INTEGER;

begin
  J := 1 + (97 * Y) DIV M;

  if (J < 1) then J := 1
  else if (J > 97) then J := 97;

  Y      := R[J];
  Random := Y * RM;
  Seed   := (IA * Seed + IC) MOD M;
  R[J]   := Seed;
end;

{----------------------------------------------------------------------}
{        Decode --- Decryption of text using Vigenere algorithm        }
{----------------------------------------------------------------------}
PROCEDURE Decode(VAR Message : AnyStr);

VAR
   I : INTEGER;

begin
  for I := 1 to LENGTH(Message) do
    Message[I] := CHR((ORD(Message[I]) - Blank_Char + Span -
                       TRUNC(Random(RanSeed) * Span)) MOD Span +
                       Blank_Char);
end;

{----------------------------------------------------------------------}
{         LXOR --- Find logical exclusive OR of two integers           }
{----------------------------------------------------------------------}
FUNCTION LXOR(I,J : LONGINT) : LONGINT;
begin
  LXOR := I XOR J;
end;

{----------------------------------------------------------------------}
{  LSHL --- Perform left shift of integer by specified # of bits       }
{----------------------------------------------------------------------}
FUNCTION LSHL(I : LONGINT; NBits : INTEGER) : LONGINT;
begin
  LSHL := I SHL NBits;
end;

{----------------------------------------------------------------------}
{     Calc_Hash --- Hash key string to find seed for random number     }
{----------------------------------------------------------------------}
FUNCTION Calc_Hash(Key : AnyStr) : LONGINT;

VAR
   I   : INTEGER;
   Sum : LONGINT;

begin
  Sum := 0;  { Exclusive OR characters together }
  for I := 1 to LENGTH(Key) do Sum := LXOR(LSHL(Sum,1),ORD(Key[I]));

  { Square result and subtract 31 to produce initial seed }
  Calc_Hash := Sum * Sum - 31;
end;

{----------------------------------------------------------------------}
{     Init_Hash --- Initialize for key string hashing                  }
{----------------------------------------------------------------------}
PROCEDURE Init_Hash;
begin
  RanSeed := Calc_Hash(StringKey);  { Initialize random number from key }
  SetRandom(RanSeed);
end;


{========================================================================}


BEGIN
  { Key for Encryption/Decryption }
  StringKey := S_Key;
END.